program FIXPOINT;
{--------------------------------------------------------------------}
{  Alg2'1.pas   Pascal program for implementing Algorithm 2.1        }
{                                                                    }
{  NUMERICAL METHODS: Pascal Programs, (c) John H. Mathews 1995      }
{  To accompany the text:                                            }
{  NUMERICAL METHODS for Math., Science & Engineering, 2nd Ed, 1992  }
{  Prentice Hall, Englewood Cliffs, New Jersey, 07632, U.S.A.        }
{  Prentice Hall, Inc.; USA, Canada, Mexico ISBN 0-13-624990-6       }
{  Prentice Hall, International Editions:   ISBN 0-13-625047-5       }
{  This free software is compliments of the author.                  }
{  E-mail address:       in%"mathews@fullerton.edu"                  }
{                                                                    }
{  Algorithm 2.1 (Fixed Point Iteration).                            }
{  Section   2.1, Iteration for Solving  x = g(x), Page 51           }
{--------------------------------------------------------------------}

  uses
    crt;

  const
    Max = 300;
    FunMax = 9;
    GNmax = 230;
    MaxN = 300;

  type
    VECTOR = array[0..2] of real;
    PVECTOR = array[0..Max] of real;
    RVECTOR = array[0..GNmax] of real;
    LETTER = string[8];
    LETTERS = string[200];
    Status = (Computing, Done, More, Working);
    DoSome = (Go, Stop);

  var
    Cond, FunType, Inum, Kcount, Sub: integer;
    DNpts, GNpts, N: integer;
    P0, Pnew, Pterm, Rnum, Tol: real;
    A, B, C, D, Xmax, Xmin, Ymax, Ymin: real;
    Ans: CHAR;
    P: VECTOR;
    VP: PVECTOR;
    Xg, Yg: RVECTOR;
    Stat, State: Status;
    DoMo: DoSome;
    Mess: LETTERS;

  function G (X: real): real;
  begin
    case FunType of
      1:
        G := 0.9 + X - 0.4 * X * X;
      2:
        G := 1.0 + X - X * X / 4;
      3:
        G := SQRT(6 + X);
      4:
        if X <> 0 then
          G := 1 + 2 / X
        else
          G := 1E12;
      5:
        G := 18 * X / (X * X + 9);
      6:
        G := X * X * X - 24;
      7:
        G := 2 * X * X * X / (3 * X * X - 9);
      8:
        if 2.25 <= X then
          G := 3 * SQRT(X - 2.25)
        else
          G := X;
      9:
        G := 2 + 2 * X - X * X;
    end;
  end;

  procedure PRINTFUNCTION (FunType: integer);
  begin
    case FunType of
      1:
        WRITELN('g(x) = 0.9 + x - 0.4 x^2');
      2:
        WRITELN('g(x) = 1.0 + x - x^2/4');
      3:
        WRITELN('g(x) = SQRT(6 + x)');
      4:
        WRITELN('g(x) = 1 + 2/x');
      5:
        WRITELN('g(x) = 18 x/(x^2 + 9)');
      6:
        WRITELN('g(x) = x^3 - 24');
      7:
        WRITELN('g(x) = 2x^3/(3 x^2 - 9)');
      8:
        WRITELN('g(x) = 3 SQRT(x - 2.25)');
      9: 
        WRITELN('g(x) = 2 + 2x - x^2');
    end;
  end;

  procedure FIXPOINTITERATE ( {FUNCTION G(X: real): real;}
                  var Pterm: real; Max: integer; Tol: real; var Pnew: real; var Cond, Kcount: integer);
    label
      999;
    const
      Big = 1E10;
      Small = 1E-20;
    var
      Dx, Dg, Pold, RelErr, Slope: real;
  begin
    VP[0] := Pterm;
    RelErr := 1;
    Pnew := G(Pterm);
    VP[1] := Pnew;
    Kcount := 0;
    while ((RelErr >= Tol) and (KCount <= Max)) do
      begin
        if Kcount <= 2 then
          P[Kcount] := Pterm;
        Pold := Pterm;
        Pterm := Pnew;
        Pnew := G(Pterm);
        VP[Kcount + 2] := Pnew;
        Dg := Pnew - Pterm;
        RelErr := ABS(Dg);  {  /(ABS(Pnew)+Small);  }
        Kcount := Kcount + 1;
        if (Pnew < -Big) or (Big < Pnew) then
          goto 999;
      end;
999:
    if Kcount <= 2 then
      P[Kcount] := Pterm;
    if Dg = 0 then
      Slope := 0
    else
      begin
        Dx := Pterm - Pold;
        if Dx <> 0 then
          Slope := Dg / Dx
        else
          Slope := 6.023E23;
      end;
    if ABS(Slope) < 1 then
      begin
        Cond := 1;
        if Slope < 0 then
          Cond := 2;
      end
    else
      begin
        Cond := 3;
        if Slope < 0 then
          Cond := 4;
      end;
    if RelErr < Tol then
      if (Cond = 3) or (Cond = 4) then
        Cond := 5;
    Kcount := Kcount + 1;
  end;

  procedure MESSAGE (var Tol: real);
    var
      I: integer;
  begin
    CLRSCR;
    WRITELN('                           FIXED POINT ITERATION');
    WRITELN;
    WRITELN;
    WRITELN('         Fixed point iteration is used to find a solution of the equation');
    WRITELN;
    WRITELN;
    WRITELN('                                 x  =  g(x) .');
    WRITELN;
    WRITELN;
    WRITELN('     An initial starting value  p   must be given, then the sequence of ');
    WRITELN('                                 0  ');
    WRITELN;
    WRITELN('     values  { p  }  is generated by using the iterative rule');
    WRITELN('                k');
    WRITELN;
    WRITELN('                        p    =  g(p )    for  k = 0,1,2,... .');
    WRITELN('                         k+1       k');
    WRITELN;
    WRITELN;
    WRITELN('     If   lim  p  =  P,  then  P = g(P)  is a fixed point of  g(x) .');
    WRITELN('         k->oo  k ');
    WRITELN;
    WRITELN;
    WRITE('                           Press the <ENTER> key.  ');
    READLN(Ans);
    WRITELN;
    CLRSCR;
    for I := 1 to 6 do
      WRITELN;
    WRITELN;
    WRITELN('          Convergence will be declared when consecutive terms in');
    WRITELN;
    WRITELN;
    WRITELN('     the sequence differ by less than the preassigned value  TOL .');
    WRITELN;
    WRITELN;
    WRITELN('     that is,         | P  - P    | < TOL');
    WRITELN('                         N    N-1  ');
    WRITELN;
    Tol := 0.000000001;
    Mess := '     ENTER the convergence criterion  TOL = ';
    WRITE(Mess);
    READLN(Tol);
    if Tol < 0.000000001 then
      Tol := 0.000000001;
  end;

  procedure GETFUN (var FunType: integer);
    var
      K: integer;
  begin
    CLRSCR;
    WRITELN('     Fixed point iteration is used to solve the equation:');
    WRITELN;
    WRITELN('                x = g(x) , where:');
    WRITELN;
    for K := 1 to FunMax do
      begin
        WRITE('     <', K : 2, ' >   ');
        PRINTFUNCTION(K);
        WRITELN;
      end;
    Mess := '     SELECT your function  < 1 - 9 > ? ';
    WRITE(Mess);
    READLN(FunType);
    if FunType < 1 then
      FunType := 1;
    if FunType > FunMax then
      FunType := FunMax;
  end;

  procedure GETPOINT (var P0, Pterm: real; FunType: integer);
  begin
    CLRSCR;
    WRITELN;
    WRITELN;
    WRITELN;
    WRITELN('          You chose to solve the equation:');
    WRITELN;
    WRITELN('                x = g(x),');
    WRITELN;
    WRITE('     where   ');
    PRINTFUNCTION(FunType);
    WRITELN;
    WRITELN;
    WRITELN;
    Mess := '     ENTER starting value     p0 = ';
    P0 := 0;
    WRITE(Mess);
    READLN(P0);
    Pterm := P0;
    WRITELN;
  end;

  procedure CHANGEF (var P0, Pterm: real; var FunType: integer);
    type
      STATUS = (Enter, Done);
      LETTER = string[1];
    var
      I: integer;
      Stat: STATUS;
  begin
    Stat := Enter;
    while (Stat = Enter) do
      begin
        CLRSCR;
        WRITELN;
        WRITELN;
        WRITELN;
        WRITELN('     You chose to solve the equation:');
        WRITELN;
        WRITELN('                x = g(x),');
        WRITELN;
        WRITE('     where   ');
        PRINTFUNCTION(FunType);
        WRITELN;
        WRITELN;
        WRITELN;
        WRITELN('     The   tolerance  is   TOL =', Tol : 15 : 8);
        WRITELN;
        WRITELN('     The starting value is  P  =', P0 : 15 : 8);
        WRITELN('                             0');
        WRITELN;
        WRITELN;
        WRITE('     Are the values O.K. ? <Y/N>  ');
        READLN(Ans);
        WRITELN;
        if (Ans = 'N') or (Ans = 'n') then
          begin
            WRITELN('     The current tolerance TOL =', Tol : 15 : 8);
            WRITELN;
            Mess := '     ENTER a NEW tolerance TOL = ';
            WRITE(Mess);
            READLN(Tol);
            if (Tol < 0.000000001) then
              Tol := 0.000000001;
            WRITELN('     Current starting value p  =', P0 : 15 : 8);
            WRITELN('                             0');
            WRITELN;
            Mess := '     ENTER  a  NEW  value   p0 = ';
            P0 := 0;
            WRITE(Mess);
            READLN(P0);
            Pterm := P0;
          end
        else
          Stat := Done;
      end;
  end;

  procedure RESULTS (P0: real; Max: integer; Tol, Pnew, Pterm: real; Cond, Kcount: integer);
    const
      Small = 1E-20;
    var
      Delta, RelErr: real;
  begin
    CLRSCR;
    WRITE('     ');
    WRITELN('Fixed point iteration was used to find the fixed point of');
    WRITELN;
    WRITE('     ');
    PRINTFUNCTION(FunType);
    WRITELN;
    WRITELN('The starting value was  P(0) =', P[0] : 15 : 8);
    if 1 <= Kcount then
      WRITELN('                  then  P(1) =', P[1] : 15 : 8);
    if 2 <= Kcount then
      WRITELN('                   and  P(2) =', P[2] : 15 : 8);
    WRITELN;
    Delta := ABS(Pnew - Pterm);
    RelErr := Delta / (ABS(Pnew) + Small);
    if RelErr < Tol then
      begin
        WRITELN('After  ', Kcount : 3, ' iterations, the fixed point was found');
        WRITELN;
        WRITELN('    P  =', Pnew : 15 : 8);
        WRITELN;
        WRITELN('Iteration was successful.');
      end
    else
      begin
        WRITELN('The location of the fixed point is in doubt.');
        WRITELN;
        WRITELN('However, the approximation after  ', Kcount : 3, ' iterations is');
        WRITELN;
        WRITELN('P(', Kcount : 3, ') =', Pnew : 15 : 8);
      end;
    WRITELN;
    WRITELN('        ', Pnew : 15 : 8, ' = G(', Pterm : 15 : 8, '  )');
    WRITELN;
    WRITELN('Consecutive iterates are within', Delta : 15 : 8);
    WRITELN;
    WRITELN('This is less than the tolerance', TOL : 15 : 8);
    WRITELN;
    if Kcount > Max then
      begin
        WRITELN('The maximum number of iterations was exceeded.');
        WRITELN;
      end;
    case Cond of
      1: 
        begin
          WRITELN('The sequence exhibits monotone convergence.');
        end;
      2: 
        begin
          WRITELN('The sequence exhibits oscillating convergence.');
        end;
      3: 
        begin
          WRITELN('The sequence exhibits monotone divergence.');
        end;
      4: 
        begin
          WRITELN('The sequence exhibits oscillating divergence.');
        end;
    end;
  end;

  procedure PRINTAPPROXS;
    var
      J: integer;
  begin
    CLRSCR;
    WRITELN;
    WRITELN('           k             P          ');
    WRITELN('                          k         ');
    WRITELN('         ----------------------------');
    WRITELN;
    for J := 0 to Kcount do
      begin
        WRITELN('          ', J : 2, '     ', VP[J] : 15 : 8);
        WRITELN;
        if J mod 10 = 9 then
          begin
            WRITE('                  Press the <ENTER> key.  ');
            READLN(Ans);
            WRITELN;
          end;
      end;
    WRITE('                  Press the <ENTER> key.  ');
    READLN(Ans);
  end;

begin                                            {Begin Main Program}
  FunType := 1;
  DoMo := Go;
  MESSAGE(Tol);
  while DoMo = Go do
    begin
      GETFUN(FunType);
      Stat := Working;
      while Stat = Working do
        begin
          GETPOINT(P0, Pterm, FunType);
          CHANGEF(P0, Pterm, FunType);
          FIXPOINTITERATE(Pterm, Max, Tol, Pnew, Cond, Kcount);
          RESULTS(P0, Max, Tol, Pnew, Pterm, Cond, Kcount);
          WRITELN;
          WRITE('Want  to see all  of  the  approximations ?  <Y/N>  ');
          READLN(Ans);
          WRITELN;
          if (Ans = 'Y') or (Ans = 'y') then
            PRINTAPPROXS;
          WRITELN;
          WRITE('Do you want to try another starting value ?  <Y/N>  ');
          READLN(Ans);
          if (Ans <> 'Y') and (Ans <> 'y') then
            Stat := Done
        end;
      WRITELN;
      Ans := 'N';
      WRITELN;
      WRITE('Do you  want to  solve  another  equation ?  <Y/N>  ');
      READLN(Ans);
      WRITELN;
      if (Ans <> 'Y') and (Ans <> 'y') then
        DoMo := Stop;
    end;
end.                                            {End of Main Program}

